#include <bits/stdc++.h>
using namespace std;

//      Starting Kit     (START)
typedef long long ll;
#define INF INT_MAX
#define MOD (1e9+7)

#define pii pair<int, int>
#define mp make_pair

#define vi vector<int>
#define vll vector<ll>
#define vc vector<char>
#define vb vector<bool>
#define vs vector<string>
#define vvi vector<vi>
#define vii vector<pii>
#define pb push_back
#define print_vect(v) for (auto it : v) cout << it << " ";
//      Starting Kit     (END)


int V;
vi redosled;

bool BFS(vi adj[], int src, int dest, int dist[])
{

    list<int> q;
    bool visited[V];
    for (int i = 0; i < V; i++) {
        visited[i] = false;
        dist[i] = INF;
    }

    visited[src] = true;
    dist[src] = 0;
    q.push_back(src);

    while (!q.empty()) {
        int u = q.front();
        q.pop_front();
        for (int i = 0; i < adj[u].size(); i++) {
            if (visited[adj[u][i]] == false) {
                visited[adj[u][i]] = true;
                dist[adj[u][i]] = dist[u] + 1;
                q.push_back(adj[u][i]);

                // found
                if (adj[u][i] == dest)
                    return true;
            }
        }
    }

    return false;
}


int shortestPath(vi adj[], int source, int dest) {
    int dist[V];

    if (BFS(adj, source, dest, dist) == false) return -1;

    return dist[dest];
}


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    cin >> V;
    redosled.resize(V);
    vi adj[V+1];

    // array
    for (int i = 0; i < V; ++i) cin >> redosled[i];

    // edges
    for (int i = 0; i < V-1; ++i) {
        int u, v;
        cin >> u >> v;
        adj[u].pb(v);
        adj[v].pb(u);
    }

    //  queries
    int Q;
    cin >> Q;
    while (Q--) {
        int tip; cin >> tip;
        if (tip == 1) {
            int x, y; cin >> x >> y;
            int xi, yi;
            for (int i = 0; i < V; ++i) {
                if (redosled[i] == x) xi = i;
                if (redosled[i] == y) yi = i;
            }
            swap(redosled[xi], redosled[yi]);
        } else {
            int l, r, x;
            cin >> l >> r >> x; --l; --r; x;
            int sol = -1;
            for (int i = l; i <= r; ++i)
                sol = max(sol, shortestPath(adj, x, redosled[i]));
            cout << sol << endl;
        }
    }


    return 0;
}